// main.c

//
//               SOURCEFORGE.NET FIRST RELEASE
//

//
//                      CANDY CRISIS X
//
// FEATURES:
//  Runs natively on Mac OS X. Developed around Mac OS X
// Public Beta 1H39 and 2E14.
// Updated 3/25/2001 for Mac OS X 4K78--OS X 10.0.
// Updated 8/25/2001 for Mac OS X 10.0.4.
//
// ETC:
// Game functionality unchanged.
// Zerius Sound System scrapped, replaced with LibMikMod. I'm
// very unhappy with performance relative to ZSS, but on G3s and up,
// performance should not be a major concern. If only I could get
// the source to ZSS so it could be Carbonized! 
// Everything runs in one window now, instead of having
// one window per interface element. This was necessary 
// because OS X wanted to put drop shadows around everything
// and it looked pretty weird. This was also a personal pet
// peeve that I never had the motivation to fix until now.
// Controls dialog is super Aqua savvy, using Theme Text 
// and Theme Buttons.
// A couple of kludges added, to work around OS X bugs. Ugh.
//  Found bug which was causing blitter to draw larger dirty rects
// than necessary (top/left of dirty rect was always 0/0). Not sure 
// if it ever shipped like that or if this is something I changed 
// post-Candy Crisis 1.0.
// Changed cursor management since OS X cursors don't know how to
// hide and show themselves properly.
//
// UNRESOLVED:
// Stopped getting Out of Memory reports. I wonder if any of the
// Candy Crisis cleanups affected this...?
// OS X displays a line of garbage when you try to put up a totally
// blank cursor. I'm not going to spend too long analyzing this; it's
// not my bug.
// 


//                    CANDY CRISIS 1.0 UPDATE
//
// FEATURES:
//  Rebranded "Candy Crisis" at the request of Mars Candy Co.
// Many, many graphical changes as a result. (New logo thanks 
// to Bob Frasure.)
//  "Controls" button in main menu per many user requests.
//  Slightly improved error reporting. 
//  Option-key at startup to turn on "allow background tasks" 
// or "don't change resolutions." (Don't change resolutions
// requires DrawSprocket 1.7.)
//
// NONCRITICAL:
//  Fixed bug in 2P mode where game would say "Player 1 got
//  best combo!" when Player 2 really got it, and vice versa. 
//  Changed Magic Skittle ratio to 1/19 instead of 1/17, after
// watching Brett get tons of Magic Skittles at work. Hmm.
// Replaced RandomBefore with less hacked-up code, because
// Magic Skittles STILL seemed to be coming up more often than
// expected. That seemed to take care of it.
// Fixed rare bug where, after losing, the game would sometimes
// get stuck until you explicitly chose "end game." (Would manifest
// more often on a slow computer and/or when Background Tasks were
// activated.)
//
// ETC:
//  Antipiracy measures.
// Game fonts all loaded at startup time instead of dynamically,
// in an attempt to reduce the number of GWorlds which are created,
// then torn down, during the game (which could have been potentially
// fragmenting the heap, though I doubt this was a real problem).
//
// UNRESOLVED:
// Still a handful of people who get Out of Memory when they 
// try to pause a game. Damn. Hopefully now I'll at least know
// where they're dying (though I highly suspect it's InitGWorld,
// which without a stack crawl is pretty much useless info...)
// One guy says this is fixed by deleting prefs. Huh??
//

//
//                     2.0.2 UPDATE
//
// FEATURES:
//  When you continue, your score is now rolled back to what
// it was when you first started the round. This prevents people
// from racking up high scores by continuing over and over again
// on the highest board.
//  You can now clear the high score tables to their default
// values by holding delete while clicking "high scores" on the
// main screen.
//
// ETC:
// Added small picture to the controls dialog so people know
// which color is Player 1, and which is Player 2.
// Holding option while warping causes a CPU/CPU match to
// occur.
//  Changed in-game registration URL to:
// http://emulation.net/s2.com/register.html
//
// CRITICAL:
//  Fixed minor memory corruption when a bomb hits floor or
// gray Skittle. Could potentially have corrupted 3 tiles of
// opponent's board.
// Fixed bug where potential combo data would not be cleared
// when choosing "End Game" and then starting a new game, which
// led to really weird corruptions of potential combo data.
// Fixed bug where holding down button after end-credits rolled
// would cause the pause dialog to pop up on a zero-gamma screen
// (whoops).
// 
// NONCRITICAL:
// Fixed bug where dropping bomb would not display associated
// points.
// Fixed bug where dropping bomb on floor/gray Skittle would
// reward the player for "killing" empty squares, making it
// score 100x(9-number of grays in 3x3 area) as opposed to
// the correct 100x(number of blobs in 3x3 area).
// Occasionally, when Best Combo got corrupted, it would show
// the ending credits instead of displaying the Best Combo. Now
// there is code to ensure that the level # of the Best Combo 
// structure is in bounds. (If it isn't, the best combo is
// assumed to be corrupt, and it is deleted. Not the most 
// optimal solution, but what can I do?)
// If you started the tutorial, ended it, then viewed the best
// combo, you'd see a speech balloon appear for one frame.
// Fixed bug where bringing up InputSprocket dialog would 
// unload ics8's used to draw key caps (damn InputSprocket bugs).
// Does this only affect ISp < 1.7?
//  Fixed bug where bringing up InputSprocket dialog would not
// update game windows behind it after it got closed.
//
// UNRESOLVED:
//  Slow loading time issue seems to only be affecting an
// incredible minority of people. It's being caused by QuickTime
// decompressing JPEGs. I think it's not a Skittles 2 issue.
// One guy says if he quits the game, reopens it, starts a game,
// then pauses it, he gets an Out of Memory condition. He's running
// 8.6-D clean. Hmm.
//

//
//                     2.0.1 UPDATE
//
// FEATURES:
//ʥBest Combo
// New bg for level 8
// New sfx for continue sound (requested by Nathan Lamont)
//
// ETC:
// High score dialog enhanced to support Best Combo stuff
// Tutorial suggests pressing esc to set up keys now
// More aggressive AI for intellect>18 (does not percieve
// 1-level zap as advantageous)
//
// CRITICAL:
// Fix for out-of-bounds array read (->crash) inside 
// ZapScoreDisplay.
// Fixed bug where falling Skittles (in DropBlobs) would
// occasionally have their bottom half lopped off. Tough to
// see while in motion but totally obvious in screenshots.
// Fixed InputSprocket icons in ISpConfigure dialog
// Workaround for System 7 bug, where setting the 
// cursor while gamma is faded causes solid black cursor.
//
// NONCRITICAL:
// Fixed bug where char fading on blobs that were
// in motion would cause crap to appear for one frame.
// Only apparent on slow Macs or in screenshots. Otherwise
// appeared as flicker and easily dismissed.
// Cmd-tab inside High Scores or Game Over screen
// no longer leaves a white box (empty window) open
// and will not switch out with 0 gamma
// Fixed DrawSprocket bug on Macs that can't do 640x480
// (i.e. PowerBook G3 is stuck at 1024x768). The window
// would be drawn in lower-right hand corner instead of
// centered.
// Fixed bug in multipliers for getting multiple 
// colors at once. (Should have been *3/*6/*12/*24, was
// actually *3/*9/*21/*45! Ouch!)
//  Hitting cmd-Q at high score dialog would allow
// empty high score name to be added to high score table.
//
// UNRESOLVED:
// A few users report very slow loading times between
// levels and during loading sequence. Problem tends to
// be alleviated by turning on VM. Can't reproduce here.
// 

//
//                 2.0.0 INITIAL RELEASE
//


#include "main.h"
#include <Movies.h>

#include <string.h>

#include "about.h"
#include "hiscore.h"
#include "control.h"
#include "players.h"
#include "gworld.h"
#include "graphics.h"
#include "grays.h"
#include "soundfx.h"
#include "wdef.h"
#include "next.h"
#include "random.h"
#include "victory.h"
#include "score.h"
#include "graymonitor.h"
#include "midi.h"
#include "gameticks.h"
#include "level.h"
#include "opponent.h"
#include "keyselect.h"
#include "blitter.h"
#include "prefs.h"
#include "register.h"
#include "tweak.h"
#include "zap.h"
#include "pause.h"
#include "keyboard.h"
#include "stringtools.h"
#include "tutorial.h"
#include "dialog.h"
#include "RegAlgorithm.h"


DSpContextReference context = nil;
Boolean allowBackgroundTasks = false, dontChangeResolution = false;

Boolean hasAppearance11 = false;
signed char nextA[2], nextB[2], nextM[2], nextG[2], colorA[2], colorB[2],
	blobX[2], blobY[2], blobR[2], blobSpin[2], speed[2], role[2], halfway[2],
	control[2], dropping[2], magic[2], grenade[2], anim[2];
int chain[2];
long blobTime[2], startTime, endTime;
Boolean finished = false, pauseKey = false, showStartMenu = true;
signed char grid[2][kGridAcross][kGridDown], suction[2][kGridAcross][kGridDown], charred[2][kGridAcross][kGridDown], glow[2][kGridAcross][kGridDown];
Rect  playerWindowZRect, playerWindowRect[2];
Boolean playerWindowVisible[2] = { true, true };
KeyList hitKey[2];
int backgroundID = -1;
Point blobWindow[8][2];
char         registeredName[64] = "";
char         registeredKey[18] = ""; // size is strange just to perplex hackers

void main( void )
{
	Initialize( );	
	if( IsRegistered( ) ) ExitToShell();

	LoadPrefs( );
	if( !IsRegistered( ) ) Register( false );
	
	ReserveMonitor( );
	ShowTitle( );

	while( !finished )
	{
		if( showStartMenu )
		{
			GameStartMenu( );
			showStartMenu = false;
		}
		
		if( !finished )
		{
			CheckKeys( true, nil, RefreshAll );
			HandlePlayers( );
			UpdateOpponent( );
			UpdateBalloon( );
			
			if( !showStartMenu && (Button() || pauseKey) )
			{
				FreezeGameTickCount( );
				PauseMusic( );
				MaskRect( &playerWindowRect[0] );
				MaskRect( &playerWindowRect[1] );
				WaitForRelease( );
				
				HandleDialog( kPauseDialog );
								
				WaitForRelease( );
				RefreshAll( );
				ResumeMusic( );
				UnfreezeGameTickCount( );
			}
		}
	}
	
	FlushEvents( everyEvent, 0L );
	SavePrefs( );
	StopInputSprocket();
	ReleaseMonitor( );
}

void YieldToBackgroundTasks( void )
{
	if( allowBackgroundTasks )
	{
		EventRecord myEvent;
		WaitNextEvent( updateEvt, &myEvent, 0, (RgnHandle) nil );
		switch( myEvent.what )
		{	
			/* If you don't do this, the Mac OS starts sending nothing but updateEvts
			   and other applications don't get any time at all. Strange but true.    */
			   
			case updateEvt:
				BeginUpdate( (WindowPtr) myEvent.message );
				EndUpdate  ( (WindowPtr) myEvent.message );
				break;
		}
	}
}

void PointyCursor()
{
	static CCrsrHandle pointyCursor = nil;
	if( pointyCursor == nil ) pointyCursor = GetCCursor( 128 );
	SetCCursor( pointyCursor );
}

void InvisiCursor()
{
	static CCrsrHandle blankCursor = nil;
	if( blankCursor == nil ) blankCursor = GetCCursor( 129 );
	SetCCursor( blankCursor );
}

void ArrowCursor()
{
	Cursor arrowCursor;
	SetCursor( GetQDGlobalsArrow( &arrowCursor ) );
}

void MaskWindow( WindowPtr window )
{
	Point backdropLocation = {0,0}, ourLocation = {0,0};
	Rect  copyRect, windowRect;
	
	SetPort( backdropPort );
	LocalToGlobal( &backdropLocation );
	SetPortWindowPort( window );
	LocalToGlobal( &ourLocation );

	GetPortBounds( GetWindowPort(window), &windowRect );
	
	copyRect.top    = ourLocation.v - backdropLocation.v;
	copyRect.left   = ourLocation.h - backdropLocation.h;
	copyRect.bottom = copyRect.top  + windowRect.bottom - windowRect.top;
	copyRect.right  = copyRect.left + windowRect.right - windowRect.top;
	
	SetPortWindowPort( window );
	CopyBits( GetPortBitMapForCopyBits(backdropWorld), GetPortBitMapForCopyBits(GetWindowPort(window)),
				&copyRect, &windowRect, srcCopy, nil );
}

void MaskRect( Rect *r )
{
	CopyBits( GetPortBitMapForCopyBits(backdropWorld), GetPortBitMapForCopyBits(backdropPort),
				r, r, srcCopy, nil );
}

void RefreshPlayerWindow( short player )
{
	Rect fullUpdate = {0, 0, kGridDown * kBlobVertSize, kGridAcross * kBlobHorizSize };
	
	if( control[player] == kNobodyControl )
	{
		MaskRect( &playerWindowRect[player] );
	}
	else
	{
		SetUpdateRect( player, &fullUpdate );
		UpdatePlayerWindow( player );
	}
}

void RefreshAll( void )
{	
	if( context && backdropPort )
	{
		DrawBackdrop( );

		ShowGrayMonitor( 0 );
		ShowGrayMonitor( 1 );

		RefreshNext( 0 );
		RefreshNext( 1 );

		RefreshPlayerWindow( 0 );
		RefreshPlayerWindow( 1 );

		DrawFrozenOpponent( );
		DrawStage( );

		ShowScore( 0 );
		ShowScore( 1 );
	}
}

void Error( short which, Str255 extra )
{
	Str255 myString;
	
	ReleaseMonitor( );
	ArrowCursor( );
	GetIndString( myString, 131, which );
	ParamText( myString, extra, "\p", "\p" );
	Alert( dFatalErrorAlert, nil );
	ExitToShell( );
}

void Inform( short which )
{
	Str255 myString;
	
	ArrowCursor( );
	GetIndString( myString, 132, which );
	ParamText( myString, "\p", "\p", "\p" );
	Alert( dInformation, nil );
}

void WaitForRelease( void )
{	
	do
	{
		CheckKeys( false, nil, nil );
	}
	while( AnyKeyIsPressed( ) || Button() );
		
	FlushEvents( everyEvent, nil );
}

Boolean AnyKeyIsPressed( void )
{
	KeyMap km;
	const int capsKey = 0x39;
	
	GetKeys( km );
	
	((unsigned char*)km)[ capsKey>>3 ] &= ~( 1 << (capsKey&7) ); 
	
	return hitKey[0].left   || hitKey[1].left   ||
		   hitKey[0].right  || hitKey[1].right  ||
		   hitKey[0].drop   || hitKey[1].drop   ||
		   hitKey[0].rotate || hitKey[1].rotate ||
		   pauseKey         || km[0]            ||
		   km[1]            || km[2]            ||
		   km[3];
}

Boolean CommandKeyIsPressed( void )
{
	KeyMap keys;
	
	GetKeys( keys );
	return KeyIsPressed( keys, 0x37 );
}

Boolean OptionKeyIsPressed( void )
{
	KeyMap keys;
	
	GetKeys( keys );
	return KeyIsPressed( keys, 0x3a );
}

void RetrieveResources( void )
{
	                            OpeningProgress( 0, 10 );
	InitMusic( );
	InitBackdrop( );			OpeningProgress( 1, 10 );
	
	ChooseMusic( 13 );
	GetBlobGraphics( );			OpeningProgress( 2, 10 );
	
	InitNext( );				OpeningProgress( 3, 10 );
	
	InitScore( );				OpeningProgress( 4, 10 );
	
	InitGrayMonitors( );		OpeningProgress( 5, 10 );
	
	InitOpponent( );			OpeningProgress( 6, 10 );

	InitStage( );   // must run after backdrop window is open
	InitGameTickCount( );
	InitSoundEffects( );		OpeningProgress( 7, 10 );

	InitPlayers( ); // must run after backdrop window is open
	InitFont( ); 
	InitZapStyle( );// must run after fonts are inited
					            OpeningProgress( 8, 10 );
	
	InitBlitter( ); // must run after player windows are open
	InitPlayerWorlds( );  		OpeningProgress( 9, 10 );
	
	InitVictory( );	// must run after fonts are inited			
	InitTweak( );				OpeningProgress( 10, 10 );

	InitInputSprocket( ); 				
}


void CenterRectInPort( Rect *rect, CGrafPtr inside,
				   double locationX, double locationY )
{
	Point dest = {0,0};
	Rect insideRect;
	
	GetPortBounds( inside, &insideRect );
	
	dest.h = (locationX * ((insideRect.right - insideRect.left) - (rect->right - rect->left)));
	dest.h &= ~3;
	dest.v = (locationY * ((insideRect.bottom - insideRect.top) - (rect->bottom - rect->top)));

	OffsetRect( rect, -rect->left, -rect->top );
	OffsetRect( rect, dest.h, dest.v );
}

static void FixupContextToCurrentResolution( DSpContextReference *context, DSpContextAttributesPtr attr )
{
	DisplayIDType id;
	GDHandle device;
	
	DSpContext_GetDisplayID( *context, &id );
	DMGetGDeviceByDisplayID( id, &device, true );
	
	attr->displayWidth  = device[0]->gdRect.right  - device[0]->gdRect.left;
	attr->displayHeight = device[0]->gdRect.bottom - device[0]->gdRect.top;

	DSpFindBestContextOnDisplayID( attr, context, id );
}

void ReserveMonitor( void )
{
	DSpContextAttributes attr = {0};
	OSErr err;
		
	if( kUseDrawSprocket )
	{
		attr.displayWidth = 640;
		attr.displayHeight = 480;
		attr.colorNeeds = kDSpColorNeeds_Require;
		attr.backBufferDepthMask = kDSpDepthMask_16;
		attr.displayDepthMask = kDSpDepthMask_16;
		attr.backBufferBestDepth = 16;
		attr.displayBestDepth = 16;

		err = DSpStartup( );

		if( !err )
		{
			err = DSpFindBestContext( &attr, &context );
		}
		
		if( !err )
		{
			if( dontChangeResolution )
			{
				FixupContextToCurrentResolution( &context, &attr );
			}
		
			attr.pageCount = 1;
			err = DSpContext_Reserve( context, &attr );
		}
		
		if( !err ) 
		{
			err = DSpContext_SetState( context, kDSpContextState_Active );
			if( err == kDSpConfirmSwitchWarning ) err = noErr;
			InvisiCursor( );
		}
		
		if( err )
		{
			Error( errNoMonitor, "\p" );
		}
	}
	else
	{
		GDHandle monitor;
		int depth;
		Rect size;
		int message = 1;
		DialogItemIndex itemHit = -1;
		AlertStdAlertParamRec	param;
		Str255 messageString, hintString;
		
		ArrowCursor( );
		for( ;; )
		{
			monitor = GetMainDevice();
			depth   = monitor[0]->gdPMap[0]->pixelSize;
			size    = monitor[0]->gdPMap[0]->bounds;
			
			if(    (depth == 16) 
			    && ((size.right - size.left) == 640) 
			    && ((size.bottom - size.top) == 480) ) break;
			    
			param.movable 		= true;
			param.helpButton 	= false;
			param.filterProc 	= nil;
			param.defaultText 	= (StringPtr) kAlertDefaultOKText;
			param.cancelText 	= "\pRun Anyway";
			param.otherText 	= nil;
			param.defaultButton = kAlertStdAlertOKButton;
			param.cancelButton 	= nil;
			param.position 		= kWindowDefaultPosition;
			
			GetIndString( messageString, 128, message );
			GetIndString( hintString,    128, 2 );
			
			StandardAlert( kAlertCautionAlert, messageString, hintString, &param, &itemHit );
			if( itemHit == kAlertStdAlertCancelButton ) break;
			
			message = 3;
		}

		HideMenuBar();
	}

}

void ReleaseMonitor( void )
{
	OSErr err;
	
	if( context ) 
	{
		if( kGamma ) DSpContext_FadeGamma( context, 0, nil );

		err = DSpContext_SetState( context, kDSpContextState_Inactive );
		
		QuickFadeIn( nil );
		
		if( !err ) err = DSpContext_Release( context );
		if( !err ) err = DSpShutdown( );
	}
}

int Warp( void )
{
	DialogPtr myDialog;
	GWorldPtr oppWorld;
	Rect oppRect = {0, 0, 64, 64}, dialogRect;
	RGBColor saveFore, saveBack;
	short what, count;
	
	if( context )
	{
		DSpContext_SetState( context, kDSpContextState_Paused );
	}

	FlushEvents( everyEvent, 0L );
	ArrowCursor( );
	
	myDialog = GetNewDialog( dWarp, nil, kFirstWindowOfClass );
	
	ShowWindow( GetDialogWindow(myDialog) );
	SetPortDialogPort( myDialog );
	GetForeColor( &saveFore );
	GetBackColor( &saveBack );	
	ForeColor( blackColor );
	BackColor( whiteColor );

	InitGWorld( &oppWorld, &oppRect, 16 );
	for( count=0; count<12; count++ )
	{
		DrawPictInGWorld( oppWorld, 5000+count );
		GetDialogRect( myDialog, 1+count, &dialogRect );
		SetPortDialogPort( myDialog );
		CopyBits( GetPortBitMapForCopyBits(oppWorld), GetPortBitMapForCopyBits(GetDialogPort(myDialog)),
                    &oppRect, &dialogRect, srcCopy, nil );
	}
	DisposeGWorld( oppWorld );

	RGBForeColor( &saveFore );
	RGBBackColor( &saveBack );
	
	do
	{
		ModalDialog( nil, &what );
	}
	while( what > 13 );

	DisposeDialog( myDialog );
	InvisiCursor( );
	
	if( context )
	{
		DSpContext_SetState( context, kDSpContextState_Active );
		DSpContext_GetFrontBuffer( context, &backdropPort );
	}

	return what;
}

void Initialize( void )
{	
	long response;
	unsigned long seed;
	
	MoreMasters( );
	MoreMasters( );
	MoreMasters( );
	MoreMasters( );
	
	FlushEvents( everyEvent, 0L );
	InitCursor( );

	GetDateTime( &seed );
	SetQDGlobalsRandomSeed( seed );
	
	EnterMovies();
	SetMenuBar( GetNewMBar( mBar ) );
	
	if( noErr == Gestalt( gestaltAppearanceVersion, &response ) )
	{
		hasAppearance11 = (response >= 0x0110);
	}

	InitKeyboard( );
}

OSStatus LaunchURL(ConstStr255Param urlStr)
{
	OSStatus err = -1;
	ICInstance inst;
	long startSel;
	long endSel;
	
	if( ICStart != nil )
	{
		err = ICStart(&inst, 'Skit');
		if (err == noErr) {
			startSel = 0;
			endSel = urlStr[0];
			err = ICLaunchURL(inst, "\p", (char *) &urlStr[1], urlStr[0], &startSel, &endSel);
			(void) ICStop(inst);
		}
	}
	return (err);
}

void QuickFadeIn( RGBColor *color )
{
	long c;
	int percent;

	if( context )
	{
		for( percent=0; percent<100; percent += 4 )
		{
			c = TickCount( ); 
			if( kGamma ) DSpContext_FadeGamma( context, percent, color );
			while( c == TickCount( ) ) { MPYield();  }
		}
		
		if( kGamma ) DSpContext_FadeGamma( context, 100, color );
	}
}

void QuickFadeOut( RGBColor *color )
{
	long c;
	int percent;

	if( context )
	{
		for( percent=100; percent>0; percent -= 4 )
		{
			c = TickCount( ); 
			if( kGamma ) DSpContext_FadeGamma( context, percent, color );
			while( c == TickCount( ) ) { MPYield();  }
		}
		
		if( kGamma ) DSpContext_FadeGamma( context, 0, color );
	}
}

Boolean ResourceExists( OSType resType, short resID )
{
	Handle res;
	
	SetResLoad( false );
	res = Get1Resource( resType, resID );
	SetResLoad( true );
	
	if( res != nil )
	{
		ReleaseResource( res );
		return true;
	}
	else
	{
		return false;
	}
}

void ChangeTypeAndCreator( FSSpec *file, long type, long creator )
{
	FInfo fInfo;
	
	FSpGetFInfo( file, &fInfo );
	if( type )    fInfo.fdType    = type;
	if( creator ) fInfo.fdCreator = creator;
	FSpSetFInfo( file, &fInfo );
}

void GoToBackground( Boolean isFullScreen, Boolean switchFrontProcess )
{
	ProcessSerialNumber myProcess = { 0, kCurrentProcess      };
	ProcessInfoRec processInfo = {0};
	Boolean inBack = true;
	EventRecord e;
	DSpContextState state;
	OSErr err = noErr;
	
	processInfo.processInfoLength = sizeof(ProcessInfoRec);
	err = GetProcessInformation( &myProcess, &processInfo );
	
	if( err == noErr )
	{
		FlushEvents( everyEvent, 0L );

		if( isFullScreen )
		{
			StopInputSprocket( );
			PauseMusic( );
			if( context )
			{
				DSpContext_GetState( context, &state );
				DSpContext_SetState( context, kDSpContextState_Inactive );
			}

			FreezeGameTickCount( );
		}
		
		if( switchFrontProcess ) SetFrontProcess( &processInfo.processLauncher );
		ArrowCursor( );

		// dummy event loop
		do
		{
			WaitNextEvent( everyEvent, &e, 1000, (RgnHandle) nil );
			switch( e.what )
			{	
				/* Watch for reactivation. */
				
				case osEvt: 
					if( (e.message >> 24) & suspendResumeMessage)
					{
						if( e.message & 1 )	// background to foreground
						{	
							inBack = false;
						}
					}
					break;

				/* If you don't do this, the Mac OS starts sending nothing but updateEvts
				   and other applications don't get any time at all. Strange but true.    */
				   
				case updateEvt:
					BeginUpdate      ( (WindowPtr) e.message );
					SetPortWindowPort( (WindowPtr) e.message );
					EndUpdate        ( (WindowPtr) e.message );
					break;
			}
		}
		while( inBack );
		
		if( isFullScreen )
		{
			InitInputSprocket( );
			if( context )
			{
				DSpContext_SetState( context, kDSpContextState_Active );
				DSpContext_SetState( context, state );
				DSpContext_GetFrontBuffer( context, &backdropPort );				
			}
			
			ResumeMusic( );
			InvisiCursor( );
			UnfreezeGameTickCount( );
		}
	}	
}

Boolean IsRegistered( void )
{
	return ValidateCode( registeredName, registeredKey );
}

